package swt.tdd.tictactoe;

import swt.tdd.tictactoe.TicTacToe.Tile;

import static org.junit.Assert.assertEquals;

import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

public class TicTacToeTest2 {

	TicTacToe ttt = new TicTacToeImpl();
	Tile[][] board;

	@Test
	public void testIsWinner() {

		// circles win with 2nd row
		board = new Tile[][] { { Tile.NONE, Tile.CROSS, Tile.CROSS }, 
										{ Tile.CIRCLE, Tile.CIRCLE, Tile.CIRCLE }, 
										{ Tile.NONE, Tile.NONE, Tile.NONE } };
		assertEquals("Incorrect winner", Tile.CIRCLE, ttt.isWinner(board) );

		// crosses win with 3rd row
		board = new Tile[][] { 	{ Tile.NONE, Tile.CIRCLE, Tile.CROSS }, 
								{ Tile.CIRCLE, Tile.CIRCLE, Tile.NONE }, 
								{ Tile.CROSS, Tile.CROSS, Tile.CROSS } };
		assertEquals("Incorrect winner", Tile.CROSS, ttt.isWinner(board) );
		
		// ...

	}

	@Test(expected = IllegalArgumentException.class)
	public void testIsWinnerException() {

		// invalid board (numbers of rows != 3)
		/*
		Tile[][] board = new Tile[][] { { Tile.CROSS, Tile.CROSS, Tile.NONE }, 
										{ Tile.CIRCLE, Tile.NONE, Tile.NONE }, 
										{ Tile.CROSS, Tile.NONE, Tile.NONE }, 
										{ Tile.CIRCLE, Tile.NONE, Tile.NONE } };
		ttt.isWinner(board);
		*/

		// invalid board (numbers of rows != 3)
		board = new Tile[][] { 	{ Tile.NONE, Tile.CROSS, Tile.CIRCLE, Tile.CROSS }, 
								{ Tile.CIRCLE, Tile.NONE, Tile.NONE }, 
								{ Tile.CROSS, Tile.NONE, Tile.NONE } };
		ttt.isWinner(board);

		// ...
		
	}
	
}
