package com.priess.se.tdd.thirtyone;


import java.util.Set;

public interface ThirtyOne {

	/**
	 * @param own own hand cards
	 * @param others other players' hand cards
	 * @return false if any other player has a hand with a lower value than the own hand, otherwise true
	 * @throws IllegalArgumentException if any provided hand is invalid
	 */
	boolean isOwnHandLosing(Hand own, Set<Hand> others) throws IllegalArgumentException;

	/**
	 * @param hand set of hand cards
	 * @return value of the hand
	 * @throws IllegalArgumentException if an invalid hand is provided,
	 * i.e. the hand is null or contains less or more than 3 cards
	 */
	double valueOfHand(Hand hand) throws IllegalArgumentException;
}
