import static org.junit.Assert.*;

import java.awt.Point;
import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

public class NumbersTestParametrized {

	private Numbers numbers;

	@Before
	public void setUp(){
		numbers = new NumbersImpl();
	}
	
	@Parameter(0)
	public int input;

	@Parameter(1)
	public boolean expected;
	
	@Parameters
	public static List<Object[]> initTestCases() {
		return Arrays.asList(new Object[][] {
			
			{ 1, true },
			{ 2, false },
			{ 3, true },
			{ 4, false },
			{ 5, true },
			{ 6, false },
			{ 7, true },
			{ 8, false },
			{ 9, false },
			{ 10, false },
			{ 11, true },
			
		});
	
	}

	@Test
	public void testIsPrime() {		
		assertEquals("Failure - 1 is a prime number.", expected, numbers.isPrime( Integer.valueOf(input) ) );
	}

	@Test
	public void testFactorial() {
		assertEquals("Failure - Factorial wrong.", Integer.valueOf(6), numbers.factorial(3) );
		assertEquals("Failure - Factorial wrong.", Integer.valueOf(24), numbers.factorial(4) );
		// ...
	}

	@Test(expected = IllegalArgumentException.class)
	public void testFactorialException() {
		numbers.factorial(-1);
	}
	
	@Test
	public void testGetFacotors() {
		assertEquals("Failure - Factorial wrong.", Integer.valueOf(6), numbers.factorial(3) );
	}

	@Test
	public void testDoForever() {
		assertTrue("No Integer type has been returned", numbers.doForever() instanceof Integer );
	}

}
