import static org.junit.Assert.*;

import java.awt.Point;

import org.junit.Before;
import org.junit.Test;

public class MyMathImplTest {

	MyMathImpl_AfterTest5 myMath;

	@Before
	public void setUp(){
		myMath = new MyMathImpl_AfterTest5();
	}
	
	/*
	 * Test 1 - Object creation
	 * 
	 * Implementation followed by this test: MyMathImpl_AfterTest1.java
	 * 
	 */
	@Test
	public void testCreation(){
		MyMathImpl_AfterTest1 myMathImpl = new MyMathImpl_AfterTest1();
	}

	/*
	 * Test 2 - IllegalArgumentException
	 * 
	 * Implementation followed by this test: MyMathImpl_AfterTest2.java
	 * 
	 */
	@Test(expected = IllegalArgumentException.class)
	public void testEuclideanDistanceException1() {
		myMath.euclideanDistance(new Point(0, 0), null);
	}	

	@Test(expected = IllegalArgumentException.class)
	public void testEuclideanDistanceException2() {
		myMath.euclideanDistance(null, new Point(0, 0));
	}	

	@Test(expected = IllegalArgumentException.class)
	public void testEuclideanDistanceException3() {
		myMath.euclideanDistance(null, null);
	}	
	
	/*
	 * Test 3 - testOneEuclideanDistance
	 * 
	 * Implementation followed by this test: MyMathImpl_AfterTest3.java
	 * 
	 */
	@Test
	public void testOneEuclideanDistance() {
		double d = myMath.euclideanDistance(new Point(0, 0), new Point(3, 4));
		assertEquals("Failure - Euclidean Distance incorrect.", 5, d, 0);
	}
	
	/*
	 * Test 4 - testMultipleEuclideanDistances
	 * 
	 * Implementation followed by this test: MyMathImpl_AfterTest4.java
	 * 
	 */
	@Test
	public void testMultipleEuclideanDistances() {
		// Use of parametrized approach for a higher test convenience is reasonable
		
		double d = myMath.euclideanDistance(new Point(0, 0), new Point(3, 4));
		assertEquals("Failure - Euclidean Distance incorrect.", 5, d, 0);

		d = myMath.euclideanDistance(new Point(2, 3), new Point(3, 4));
		assertEquals("Failure - Euclidean Distance incorrect.", 1.41, d, 0.01);

		d = myMath.euclideanDistance(new Point(0, 0), new Point(5, 3));
		assertEquals("Failure - Euclidean Distance incorrect.", 5.83, d, 0.01);

		d = myMath.euclideanDistance(new Point(7, 8), new Point(3, 4));
		assertEquals("Failure - Euclidean Distance incorrect.", 5.65, d, 0.01);		
		// ... more tests
	}

	/*
	 * Test 5 - testLogin
	 * 
	 * Implementation followed by this test: MyMathImpl_AfterTest5.java
	 * 
	 */
	@Test
	public void testLogin() {
		// Use of parametrized approach for a higher test convenience is reasonable
		assertEquals( "Failure - Login incorrect", true, myMath.login("Hans", "1234") );
		assertEquals( "Failure - Login incorrect", false, myMath.login("Hans", "1235") );
		assertEquals( "Failure - Login incorrect", true, myMath.login("Wurst", "5678") );
		assertEquals( "Failure - Login incorrect", false, myMath.login("Wurst", "5688") );
		// ... more tests
	}

}
