import java.awt.*;
import java.util.HashMap;
import java.util.Map;

/**
 * Klasse zur Demonstration von einfachen Unit-Tests.
 * @author Malte Prieß
 */
public class MyMathImpl implements MyMath {

	private Map<String, String> loginData;
	
	public MyMathImpl(){
		loginData = new HashMap<>();
		loginData.put("Hans", "1234");
		loginData.put("Wurst", "5678");
	}

	public double euclideanDistance(Point a, Point b) throws IllegalArgumentException {
		if (a == null || b == null)
			throw new IllegalArgumentException("Null is not allowed as argument.");
		
		int delta_x = a.x - b.x;
		int delta_y = a.y - b.y;
		
		/*
		if (a.x == b.x)
			return Math.abs(delta_y);
		else if (a.y == b.y)
			return Math.abs(delta_x);
		else
			return Math.sqrt(delta_x * delta_x + delta_y * delta_y);
		*/
		return Math.sqrt(delta_x * delta_x + delta_y * delta_y);
	}
	
	public boolean login(String user, String pass) {
		if ( loginData.get(user) == pass )
			return true;
		
		return false;
	}
	
}

