import static org.junit.Assert.*;

import java.awt.Point;
import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

/**
 * Parametrisierter Test für die Klasse {@link MyMathImpl} unter Verwendung der 
 * {@link org.junit.runners.Parameterized.Parameter} Annotation.
 * 
 * Der Einfachtheit halber wird der parametrisierte Test hier lediglich für die Funktion 
 * {@link MyMathImpl#euclideanDistance(Point a, Point b)} demonstriert.
 */
@RunWith(Parameterized.class)
public class MyMathTestParametrized1 {

	MyMathImpl myMath;

	@Before
	public void setUp(){
		myMath = new MyMathImpl();
	}

	@Parameter(0)
	public Point point1;

	@Parameter(1)
	public Point point2;
	
	@Parameter(2)
	public double expectedEuclideanDistance;	
	
	@Parameter(3)
	public double delta;	

//	@Parameters
	/*
	 * In order that you can easily identify the individual tests, 
	 * you may provide a name for the @Parameters annotation. 
	 * This name is allowed to contain placeholders, which are replaced 
	 * at runtime. The placeholders are: 
	 * {index} the current parameter index
	 * {0} the first parameter value
	 * {1} the second parameter value
	 * ...
	 */
	//@Parameters(name= "{index}: euclDist[{0},{1}]={2}")
	@Parameters
	public static List<Object[]> initTestCases() {
		return Arrays.asList(new Object[][] {
			
			// { point1, point2, expectedEuclideanDistance, delta }
			{ new Point(0, 0), new Point(3, 4), 5.0, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			{ new Point(2, 3), new Point(3, 4), 1.41, 0 },
			
		});
	
	}
	
	/*
	 * Each instance of initTestCases will be constructed with 
	 * the default constructor and fields annotated by @Parameter 
	 * will be initialized with the data values in the @Parameters method.
	 */
	@Test
	public void testEuclideanDistance() {
		assertEquals("Failure - Euclidean Distance incorrect.", 
				expectedEuclideanDistance, 
				Math.round( myMath.euclideanDistance(point1, point2) * 100 ) / 100.0, 
				delta );
	}
		
}
