

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/*
 * Ein Warenkorb enthält eine Liste von Büchern, die bestellt werden,
 * und eine Methode, die den Preis für diese Bücher berechnet.
 */
public class ShoppingCartImpl implements ShoppingCart {
	
	private List<Book> bookList;

	@Override
	public void setBookList( List<Book> bookList ) {
		this.bookList = bookList;
	}
	
	public List<Book> getBooks() {
		return bookList;
	}
	
	public double getPrice() {
				
		/*
		 * 1st implementation: Without price reduction
		 */
		/*
		for ( Book b : bookList ){
			price += b.getSeries().getPricePerBook();
		}
		*/

		/*
		 * 2nd implementation: With price reduction
		 */
		Map<String, Double> pricePerSeries = new HashMap<String, Double>();
		Map<String, Integer> countPerSeries = new HashMap<String, Integer>();
			
		for ( Book b : bookList ){
			
			if ( pricePerSeries.containsKey( b.getSeries().getSeriesName() ) == false ){
				
				pricePerSeries.put( b.getSeries().getSeriesName(), 
						b.getSeries().getPricePerBook() );
				
				countPerSeries.put( b.getSeries().getSeriesName(), 1 );
				
			} else {
				
				pricePerSeries.put( b.getSeries().getSeriesName(), 
						pricePerSeries.get( b.getSeries().getSeriesName() ) + b.getSeries().getPricePerBook() );
			
				countPerSeries.put( b.getSeries().getSeriesName(),
						countPerSeries.get( b.getSeries().getSeriesName() ) + 1 );
			
			}
			
		}
	
		Double priceTotal = 0.0;
		for ( String bSeries : pricePerSeries.keySet() ){
		
			//System.out.print( "Book series = " + bSeries + ", price = " + pricePerSeries.get( bSeries ) );
		    
			if ( countPerSeries.get( bSeries ) == 2 ){
				priceTotal += pricePerSeries.get( bSeries ) * 0.95;

			} else if ( countPerSeries.get( bSeries ) == 3 ){
				priceTotal += pricePerSeries.get( bSeries ) * 0.9;
			
			} else if ( countPerSeries.get( bSeries ) == 4 ){
				priceTotal += pricePerSeries.get( bSeries ) * 0.8;
			
			} else if ( countPerSeries.get( bSeries ) >= 5 ){
				priceTotal += pricePerSeries.get( bSeries ) * 0.75;
			
			} else {
				priceTotal += 0.0;
			}
			
		}
		
		return priceTotal;

	}

}
