require("dotenv").config();
const config = require("config");
const chalk = require("chalk");
const express = require("express");
const cors = require("cors");
const morgan = require("morgan");
const connectDB = require("./config/db");
const { createHandler } = require("graphql-http/lib/use/express");
const schema = require("./schema/schema");

const app = express();

connectDB();

if (config.get("NODE_ENV") === "development") {
  app.use(morgan("dev"));
}

app.use(cors());

app.use(express.json({ extended: false, limit: 100000 }));

app.use("/api/clients", require("./routes/api/clients"));
app.use("/api/projects", require("./routes/api/projects"));

app.all("/graphql", createHandler({ schema }));

// Serve static assets in production
if (config.get("NODE_ENV") === "production") {
  app.use(express.static("client/build"));

  app.get("*", (req, res) => {
    res.sendFile(path.resolve(__dirname, "client", "build", "index.html"));
  });
}

// Create sample data
require("./sample-data").create();

const PORT = config.get("PORT");

app.listen(PORT, () => {
  console.log(chalk.green(`App listening on port ${PORT}`));
});
