const chalk = require("chalk");
const Client = require("./models/Client");
const Project = require("./models/Project");

const clients = [
  {
    name: "Tony Stark",
    email: "ironman@gmail.com",
    phone: "343-567-4333",
  },
  {
    name: "Natasha Romanova",
    email: "blackwidow@gmail.com",
    phone: "223-567-3322",
  },
  {
    name: "Thor Odinson",
    email: "thor@gmail.com",
    phone: "324-331-4333",
  },
  {
    name: "Steve Rogers",
    email: "steve@gmail.com",
    phone: "344-562-6787",
  },
  {
    name: "Bruce Banner",
    email: "bruce@gmail.com",
    phone: "321-468-8887",
  },
];

const projects = [
  {
    name: "eCommerce Website",
    description:
      "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    status: "In Progress",
  },
  {
    name: "Dating App",
    description:
      "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    status: "In Progress",
  },
  {
    name: "SEO Project",
    description:
      "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    status: "In Progress",
  },
  {
    name: "Design Prototype",
    description:
      "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    status: "Completed",
  },
  {
    name: "Auction Website",
    description:
      "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    status: "In Progress",
  },
];

function create() {
  console.log(chalk.yellow("Creating sample data..."));

  for (const [i, client] of clients.entries()) {
    new Client({
      name: client.name,
      email: client.email,
      phone: client.phone,
    })
      .save()
      .then((client) => {
        const project = projects[i];

        new Project({
          client: client._id,
          name: project.name,
          status: project.status,
          description: project.description,
        }).save();
      });
  }

  console.log(chalk.green("Done creating sample data!"));
}

module.exports = { create };
