const mongoose = require("mongoose");

const ProjectSchema = new mongoose.Schema({
  client: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "client",
  },
  name: {
    type: String,
    maxLength: 100,
    required: true,
  },
  status: {
    type: String,
    enum: ["Not Started", "In Progress", "Completed"],
    required: true,
  },
  description: {
    type: String,
    maxLength: 1000,
    required: true,
  },
});

module.exports = Project = mongoose.model("project", ProjectSchema);
