show databases;
drop database if exists mgmt;
create database mgmt;
use mgmt;
show tables;
create table client (
  id int not null,
  name varchar(100) not null,
  email varchar(100) not null,
  phone varchar(100) not null,
  primary key (id)
);
desc client;
create table project (
  id int not null,
  name varchar(100) not null,
  status enum ("Not Started", "In Progress", "Completed") not null,
  description varchar(1000) not null,
  clientId int not null,
  primary key (id),
  foreign key (clientId) references client(id)
);
desc project;
insert into client (id, name, email, phone)
values (
    1,
    "Tony Stark",
    "ironman@gmail.com",
    "343-567-4333"
  );
insert into client (id, name, email, phone)
values (
    2,
    "Natasha Romanova",
    "blackwidow@gmail.com",
    "223-567-3322"
  );
insert into client (id, name, email, phone)
values (
    3,
    "Thor Odinson",
    "thor@gmail.com",
    "324-331-4333"
  );
insert into client (id, name, email, phone)
values (
    4,
    "Steve Rogers",
    "steve@gmail.com",
    "344-562-6787"
  );
insert into client (id, name, email, phone)
values (
    5,
    "Bruce Banner",
    "bruce@gmail.com",
    "321-468-8887"
  );
select *
from client;
insert into project (id, name, status, description, clientId)
values (
    1,
    "eCommerce Website",
    "In Progress",
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    1
  );
insert into project (id, name, status, description, clientId)
values (
    2,
    "Dating App",
    "In Progress",
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    1
  );
insert into project (id, name, status, description, clientId)
values (
    3,
    "SEO Project",
    "In Progress",
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    1
  );
insert into project (id, name, status, description, clientId)
values (
    4,
    "Design Prototype",
    "Completed",
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    1
  );
insert into project (id, name, status, description, clientId)
values (
    5,
    "Auction Website",
    "In Progress",
    "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu.",
    1
  );
select *
from project;
select p.name,
  p.status,
  client.name
from (
    select *
    from project
    where id = 1
  ) as p
  join client on p.clientId = client.id;