const chalk = require("chalk");
const mongoose = require("mongoose");

const uri = process.env.MONGO_URI;

const connectDB = async () => {
  try {
    const conn = await mongoose.connect(uri, {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });
    console.log(
      chalk.green(`Connected with MongoDB on ${conn.connection.host}`)
    );
  } catch (error) {
    console.log(chalk.red.bold(`Error: ${error.message}`));
    console.log(chalk.red.bold(`Error: ${error}`));
    process.exit(1);
  }
};

module.exports = connectDB;
