import { ApolloProvider, ApolloClient, InMemoryCache } from "@apollo/client";
import Clients from "./Clients";

const cache = new InMemoryCache({
  typePolicies: {
    Query: {
      fields: {
        clients: {
          merge(existing, incoming) {
            return incoming;
          },
        },
        projects: {
          merge(existing, incoming) {
            return incoming;
          },
        },
      },
    },
  },
});

const client = new ApolloClient({
  uri: "http://localhost:5000/graphql",
  cache,
});

export default function Main() {
  return (
    <ApolloProvider client={client}>
      <Clients />
    </ApolloProvider>
  );
}
