import { useQuery } from "@apollo/client";
import Client from "./Client";
import { GET_CLIENTS } from "./queries/clients";

export default function Clients() {
  const { loading, error, data } = useQuery(GET_CLIENTS);

  if (loading) return <p>Loading...</p>;

  if (error) return <p>Something went wrong!</p>;

  return (
    <>
      {!loading && !error && (
        <table className="u-full-width">
          <thead>
            <tr>
              <th>Name</th>
              <th>Email</th>
              <th>Phone</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            {data.clients.map((client) => (
              <Client key={client.id} client={client} />
            ))}
          </tbody>
        </table>
      )}
    </>
  );
}
