import { useMutation } from "@apollo/client";
import { DELETE_CLIENT } from "./mutations/clients";
import { GET_CLIENTS } from "./queries/clients";

export default function Client({ client }) {
  const [deleteClient] = useMutation(DELETE_CLIENT, {
    variables: { id: client.id },
    // refetchQueries: [{ query: GET_CLIENTS }],
    // update(cache, { data: { deleteClient } }) {
    //   const { clients } = cache.readQuery({ query: GET_CLIENTS });
    //   cache.writeQuery({
    //     query: GET_CLIENTS,
    //     data: {
    //       clients: clients.filter((client) => client.id !== deleteClient.id),
    //     },
    //   });
    // },
  });

  return (
    <tr>
      <td>{client.name}</td>
      <td>{client.email}</td>
      <td>{client.phone}</td>
      <td>
        <button className="button button-small" onClick={deleteClient}>
          <i className="fa-solid fa-trash"></i>
        </button>
      </td>
    </tr>
  );
}
