import GraphiQL from "graphiql";
import "graphiql/graphiql.min.css";
import Main from "./Main";

const App = () => (
  <div style={{ height: "100vh" }}>
    <GraphiQL
      fetcher={async (graphQLParams) => {
        const data = await fetch("http://localhost:5000/graphql", {
          method: "POST",
          headers: {
            Accept: "application/json",
            "Content-Type": "application/json",
          },
          body: JSON.stringify(graphQLParams),
          credentials: "same-origin",
        });
        return data.json().catch(() => data.text());
      }}
    />
    <Main />
  </div>
);

export default App;
