# graphql

Introduction to GraphQL

## Technology

[GraphQL](https://graphql.org/), [GraphiQL](https://www.npmjs.com/package/graphiql), and [Apollo Client](https://www.npmjs.com/package/@apollo/client).

## Objective

Build a full stack web application based on GraphQL.

## References

- [Introduction to GraphQL](https://graphql.org/learn/)

## Development

### Implement Domain Model with SQL

Start [MySQL](https://hub.docker.com/_/mysql) in a Docker container.

```bash
docker run -d --name mysql -p 3306:3306 -e MYSQL_ROOT_PASSWORD=pwd mysql:latest
```

Connect with [MySQL Workbench](https://www.mysql.com/products/workbench/) and implement the [relational domain model](./mgmt.sql).

With a single SQL query you can then query _exactly_ what you need.

```sql
select p.name,
  p.status,
  client.name
from (
    select *
    from project
    where id = 1
  ) as p
  join client on p.clientId = client.id;
```

### Create a MongoDB Database

Start up a MongoDB cluster.

```bash
docker compose -f mongo-docker-compose.yml up
```

Browse to the [Mongo Express Dashboard](http://localhost:8081/) and create an _mgmt_ database.

With MongoDB compass, connect to the MongoDB cluster and database with the following connection string.

```bash
mongodb://root:pwd@localhost:27017/mgmt?authMechanism=DEFAULT&authSource=admin
```

### Create a REST API

Implement CRUD operations for _clients_ and _projects_.

- Create client/project
- Update client/project
- Get all clients/projects
- Get client/project
- Delete client/project

### Create GraphQL Server

```bash
npm install graphql graphql-http
```

### Create a React App

```bash
npx create-react-app client
```

### Use a GraphiQL Frontend

[GraphiQL](https://www.npmjs.com/package/graphiql) is the GraphQL integrated development environment.

```bash
npm install graphql graphiql
```

Again, a single GraphQL query suffices for our information needs.

```json
{
  project(id: "64271194e81c01c3ec14325d") {
    name
    status
    client {
      name
    }
  }
}
```

### Create an Apollo Client

```bash
npm install @apollo/client
```

Set up Apollo provider to have child components access the Apollo client.

The Apollo provider is the state manager for our GraphQL data.
