**Author**: Prof. Dr. Malte Prieß
**Datum**: Aug 2023
**Thema**: Git Branching, baut auf dem Teil [Git Basics](./Git_Teil1_Basics.md) auf.
**Quelle(n)**: Das folgende Beispiel ist durch https://git-scm.com/book/de/v1/Git-Branching-Einfaches-Branching-und-Merging motiviert.

---

**Beispiel A.1 (Merge ohne Konflikt)**:

  -	Neue Funktionalität: Neuen (Funktions)Branch TESTCLA1-2 erstellen und auschecken (`git checkout -b TESTCLA1-2` oder `git branch TESTCLA1-2` und `git checkout TESTCLA1-2`)

  -	Beginne Arbeit auf TESTCLA1-2 (div-Gerüst einfügen ohne Rumpf)

  -	Änderungen auf lokalen Branch TESTCLA1-2 commiten (`git commit -a -m 'Started work on footer [issue TESTCLA1-2]'`)

  - Ggf. lokalen Branch auf den Server pushen (`git push origin TESTCLA1-2`)

  - Andere Teammitglieder können diesen Branch vom Remote pullen über: `git checkout --track origin/TESTCLA1-2`

  Basierend auf dem Remote-Branch "origin/TESTCLA1-2", gibt es dann einen neuen lokalen Branch "TESTCLA1-2" der den Remote-Branch verfolgt. Zu beachten ist, dass Git standardmäßig denselben Namen für den lokalen Zweig verwendet. Da dies eine gute Konvention ist, besteht selten die Notwendigkeit, dies zu ändern.

  -	Meldung vom Teamleiter über akut notwendigen Hotfix: Zurück zum master Branch wechseln (`git checkout master`)

  -	Neuen (Hotfix)Branch TESTCLA1-1 erstellen und auschecken (`git checkout -b TESTCLA1-1`)

  -	Typos bereinigen und auf (Hotfix)Branch TESTCLA1-1 commiten (`git commit -a -m 'Fixed typos in title [issue TESTCLA1-1]'`)

  -	Zurück zum master Branch wechseln (`git checkout master`)

  -	Merge des (Hotfix)Branch TESTCLA1-1 mit master Branch (`git merge TESTCLA1-1`)

  -	Beachte Mitteilung „Fast-forward“ (da der neue Commit direkt von dem ursprünglichen Commit, auf den sich der nun eingebrachte Zweig bezieht, abstammt, bewegt Git einfach den Zeiger weiter)

  -	Modifikationen auf dem remote Repository veröffentlichen (`git push origin master`)

  -	Nutzlosen (Hotfix)Branch löschen (`git branch -d TESTCLA1-1`)

  -	Wechsel erneut zum vorher erstellten (Funktions)Branch TESTCLA1-2 (`git checkout TESTCLA1-2`)

  -	Beende Arbeit im (Funktions)Branch TESTCLA1-2 (Rumpf vom footer-div ergänzen)

  -	Änderungen auf lokalen Branch TESTCLA1-2 commiten (`git commit -a -m 'Finished work on footer [issue TESTCLA1-2]'``)

  -	Zurück zum master Branch wechseln (`git checkout master`)

  -	Merge des (Funktions)Branch TESTCLA1-2 mit master Branch (`git merge TESTCLA1-2`)

  -	Beachte Mitteilung „Merge made by the 'recursive' strategy.“ Hier haben sich die Entwicklungsstränge schon zu einem früheren Zeitpunkt geteilt. Da der Commit auf dem (Funktions)Branch TESTCLA1-2 kein direkter Nachfolger von dem master Branch ist, in den das merge gemacht werden soll, hat Git einiges zu tun. Dazu macht Git einen sog. 3-Wege Merge, wobei es die beiden Schnappschüsse verwendet, welche auf die Enden der Branches zeigen, und den gemeinsamen Vorfahren dieser beiden.

  -	Nutzlosen (Funktions)Branch löschen (`git branch -d TESTCLA1-2`)
  	-	Ggf. Remote-Branch löschen (`git push origin --delete TESTCLA1-2`)

  -	Resultat: Automatischer Merge ohne Konflikte

  -	Modifikationen veröffentlichen (`git push origin master`)

**Beispiel A.2 (Merge mit Konflikt)**:

  -	Wie bei A.1, hier nur in der Bearbeitung des (Funktions)Branch TESTCLA1-2 ebenfalls einen Typo im Titel bereinigen, also dieselbe Zeile editieren (aber anders) wie im (Hotfix)Branch TESTCLA1-1

  -	Resultat: Automatischer Merge nicht möglich, da Konflikt in doppelt bearbeiteter Titelzeile auftritt

  -	Im Falle eines solchen Konfliktes würde die betroffene Datei dann folgende Elemente enthalten:

  `<<<<<<< HEAD [Code aus dem aktuell „ausgecheckten“ Branch] ======= [Code aus dem branch TESTCLA1-2, der mit dem aktuell „ausgecheckten“ Branch zusammengeführt werden soll] >>>>>>> TESTCLA1-2`

  und der Konflikt muss manuell durch Editieren der betroffenen Datei(en) aufgelöst werden.

  -	Die so bearbeitete Datei muss ebenfalls zum Staging-Bereich hinzugefügt und commited werden (`git add … + git commit -m „…“`)

  -	Anschließend alle Modifikationen auf dem remote Master-Branch veröffentlichen (`git push origin master`)
