**Author**: Prof. Dr. Malte Prieß
**Datum**: Aug 2023
**Thema**: Git Basics
**Quelle(n)**: „Git Basics“ https://git-scm.com/book/en/v2/

---

<figure>
    <img src="https://git-scm.com/book/en/v2/images/lifecycle.png"
         alt="The lifecycle of the status of your files">
    <figcaption>The lifecycle of the status of your files (https://git-scm.com)</figcaption>
</figure>

  - [ ] **Getting a Git Repository**
    - Initializing a Repository in an Existing Directory
      `git init`
    - Cloning an Existing Repository
      `git clone https://github.com/libgit2/libgit2`

  - [ ] **Recording Changes to the Repository**
    - Checking the Status of Your Files, also Short Status
      `git status`
      `git status -s`
    - Tracking New Files
      `git add README`
    - Staging Modified Files
      `git add README`
      *Note*: `git add` is a multipurpose command — you use it to begin tracking new files, to stage files, and to do other things like marking merge-conflicted files as resolved.
    - Ignoring Files
      `.gitignore`
      (see, e.g., [Atlassian .gitignore Tutorial](https://www.atlassian.com/de/git/tutorials/saving-changes/gitignore))
    - Viewing Your Staged and Unstaged Changes
      `git diff` (see what you've changed but not yet staged)
      `git diff --staged` (`--staged` and `--cached` are synonyms) (see what you’ve staged that will go into your next commit)
    - Committing Your Changes
      `git commit`
    - Skipping the Staging Area (the -a flag includes all changed files)
      `git commit -a -m 'Add new benchmarks'`
    - Removing Files
      `git rm README` (remove a file from your staging area)
      `git rm --cached README` (keep a file in your working tree but remove it from your staging area)
    - Moving Files
      `git mv file_from file_to`

  - [ ] **Viewing the Commit History**
      `git log` (lists the commits made in that repository in reverse chronological order)
      `git log -p -2` (limit the number of log entries displayed, such as using -2 to show only the last two entries)
      `git log --stat` (see some abbreviated stats for each commit)
      `git log --pretty=oneline` (change the output format)
      `git log --pretty=format:"%h - %an, %ar : %s"`
      `git log --pretty=format:"%h %s" --graph`
      `gitk`

  - [ ] **Undoing Things**
      `git commit --amend` (redo a commit, make the additional changes you forgot, stage them, and commit again)
    - Unstaging a Staged File
      `git restore --staged README`
  	-	Unmodifying a Modified File
      `git restore README`

  - [ ]	**Working with Remotes**
  	-	Showing Your Remotes
      `git remote` (see which remote servers you have configured)
      `git remote -v` (shows you the URLs that Git has stored for the shortname to be used when reading and writing to that remote)
  	-	Adding Remote Repositories
      `git remote add mp https://gitlab.com/mpriess/dhsh_winf_se_testproject` (git remote add <shortname> <url>)

  	-	Fetching and Pulling from Your Remotes
      `git fetch <remote>` (important to note that the git fetch command only downloads the data to your local repository — it doesn’t automatically merge it with any of your work or modify what you’re currently working on)
      `git pull` (fetches data from the server you originally cloned from and automatically tries to merge it into the code you’re currently working on)
  	-	Pushing to Your Remotes
      `git push <remote> <branch>`
  	-	Inspecting a Remote
      `git remote show origin`
  	-	Renaming and Removing Remotes
      `git remote rename mp mpriess`
      `git remote remove mpriess`

  - [ ]	**Tagging**
  	-	Listing Your Tags
      `git tag`
  	-	Annotated Tags
      `git tag -a v1.4 -m 'my version 1.4'`
      `git show v1.4` (shows the tagger information, the date the commit was tagged, and the annotation message before showing the commit information)
  	-	Lightweight Tags
      `git tag v1.4-lw`
      `git show v1.4-lw` (just shows the commit, no extra tag information)
    - Tagging later
      `git tag -a v1.2 9fceb02` (to tag a commit, you specify the commit checksum (or part of it) at the end of the command)
    -	Sharing Tags
      `git push origin v1.4`
      (you will have to explicitly push tags to a shared server after you have created them)
      `git push origin --tags`
  	-	Deleting Tags
      `git tag -d v1.4-lw`
      `git push origin --delete <tagname>` (delete a remote tag)

  - [ ] **Git Aliases**
    `git config --global alias.co checkout`
    `git config --global alias.br branch`
    `git config --global alias.ci commit`
    `git config --global alias.st status && echo 'hello'`
    `git config --global alias.visual '!gitk'`
